
static const int MOTION_MAX_SAMPLES = 7;

//@:-texformat color_tex RGBA8
//@:-texformat motion_tex RGBA8

sampler2D color_tex					: register(s0);	/// color tex (with blurred mipmapped chain)
sampler2D motion_tex				: register(s2);	/// precomputed vectors of motion per fragment
sampler2D depth_tex					: register(s3);	/// depth tex (for depth restore)

uniform half4 motionParams			: register(c138);	// { shutterFactor, motionNoiseFactor, 0.0, 0.0}
uniform half4 sampleFactors[MOTION_MAX_SAMPLES]
									: register(c139);	// factors on the velocity vector for up to 8 samples

struct PS_IN
{
	half2 Texture : TEXCOORD0;
};


inline half4 motion(PS_IN In, float4 srcColor)
{
	// compute vector of motion for the fragment and multiply it by shutterFactor
	half2 vMotion = tex2D(motion_tex, In.Texture).rg * 0.2 - 0.1;

	// the first fragment
	half4 outColor = srcColor;
	half2 v;
	
	v = In.Texture + vMotion*(sampleFactors[0].xy);
	outColor += tex2D(color_tex, v);
	
	v = In.Texture + vMotion*(sampleFactors[1].xy);
	outColor += tex2D(color_tex, v);
	
	v = In.Texture + vMotion*(sampleFactors[2].xy);
	outColor += tex2D(color_tex, v);
	
	v = In.Texture + vMotion*(sampleFactors[4].xy);
	outColor += tex2D(color_tex, v);
	
	v = In.Texture + vMotion*(sampleFactors[5].xy);
	outColor += tex2D(color_tex, v);

	v = In.Texture + vMotion*(sampleFactors[6].xy);
	outColor += tex2D(color_tex, v);

	return outColor / MOTION_MAX_SAMPLES; // total fragments weights
}

//_________________________________________________________________________________________________

half4 motion_px( PS_IN In ) : COLOR
{
	return motion(In, tex2D(color_tex, In.Texture));
}

//_________________________________________________________________________________________________

void motiondepth_px(PS_IN In,
					out half4 outColor : COLOR,
					out half outDepth : DEPTH)
{
	outColor = motion(In, tex2D(color_tex, In.Texture));
	outDepth = tex2D(depth_tex, In.Texture).r;
}

//_________________________________________________________________________________________________

